#ifndef VECTEUR_H
#define VECTEUR_H

using namespace std;

//Vecteur avec surcharge des oprateurs
class Vecteur
{
 public:
        float x,y,z;//Vecteur 3D
        
        static Vecteur makeVect(float x,float y,float z);//Fonction que permet de construire un vecteur
        
        Vecteur();
        Vecteur(Vecteur &v);
        Vecteur(float x,float y,float z);
        
        Vecteur &operator=(Vecteur &v);
        
        Vecteur operator+(Vecteur &v);
        Vecteur operator-(Vecteur &v);
        
        Vecteur &operator+=(Vecteur &v);
        Vecteur &operator-=(Vecteur &v);
        
        Vecteur &operator*=(float a);
        Vecteur &operator/=(float a);
        
        //Vecteur operator-();
        
        float operator*(Vecteur &v);
        float length();//retourne la taille du vecteur
        float length2();//retourne la taille du vecteur en la laissant au carre
        
        void normalize();//normalize le vecteur
        
        void cross(Vecteur &v);//calcul le produit scalaire (rsultat mit dans this)
        void inverse();//il s'agit d'opposer le vecteur et non de l'inverser dans cette fonction
};

#endif
